#include "hal_base.h"
#include "hal_gpio.h"
#include "hal_t2n.h"
#include "hal_irq.h"


uint8_t loop;			// ִдͳ
uint16_t value = 0;		// T2ntimerֵ

/* жϷT20жϺ־ȡT20Timerֵ */
void isr(void) interrupt
{
	if (irq_get_it_status(T20VIE_IT) && irq_get_flag_status(T20VIE_IT)) {
		irq_clear_flag_status(T20VIE_IT);
		value = t2n_get_value(T20_TYPE);
		loop++;
	}
}

void main() 
{
	// T2nĳʼṹ
	t2n_init_t t_init;

	// RAMʼ
	ram_clear();
	// clockʼѡHRC,Ƶʹclock 
	clock_init(CLOCK_SRC_HRC, CLOCK_DIV_1, DISABLE);

	// ʼT20ΪTimerģʽ
	t_init.mode = T2N_TIMER_MODE;
	t_init.clk_div = T2N_CLK_DIV_1;
	t_init.period = 0x2000;
	t_init.pos = 2;
	t2n_init(T20_TYPE, &t_init);

	// ʹж
	IRQ_GIE_CFG(1);
	// ʹT20ж
	irq_config(T20VIE_IT, ENABLE);
	// T20ʱ
	t2n_start(T20_TYPE);

	while (1) {
		// ι
		CLRWDT();
	}
}